/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.fluid;

import com.technicalitiesmc.lib.container.fluid.FluidContainer;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;

public class FluidContainerSlice
implements FluidContainer {
    private final FluidContainer parent;
    private final int from;
    private final int size;

    public FluidContainerSlice(FluidContainer parent, int from, int size) {
        this.parent = parent;
        this.from = from;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public FluidStack get(int tank) {
        Objects.checkIndex(tank, this.size);
        return this.parent.get(this.from + tank);
    }

    @Override
    public void set(int tank, FluidStack stack) {
        Objects.checkIndex(tank, this.size);
        this.parent.set(this.from + tank, stack);
    }

    @Override
    public boolean isValid(int tank, FluidStack stack) {
        Objects.checkIndex(tank, this.size);
        return this.parent.isValid(this.from + tank, stack);
    }

    @Override
    public int getCapacity(int tank) {
        Objects.checkIndex(tank, this.size);
        return this.parent.getCapacity(this.from + tank);
    }
}

